<?php
require_once __DIR__ . '/BaseModel.php';

/**
 * مدل تنظیمات
 */
class SettingsModel extends BaseModel {
    protected $tableName = 'settings';
    
    /**
     * دریافت مقدار یک تنظیمات بر اساس کلید
     */
    public function getSetting($key) {
        if (empty($this->tableName)) {
            error_log("SettingsModel::getSetting: tableName is empty");
            return null;
        }
        $query = "SELECT setting_value FROM {$this->tableName} WHERE setting_key = ?";
        $result = $this->db->selectOne($query, [$key]);
        return $result && isset($result['setting_value']) ? $result['setting_value'] : null;
    }
    
    /**
     * ذخیره یا به‌روزرسانی یک تنظیمات
     */
    public function setSetting($key, $value, $updatedBy = null) {
        if (empty($this->tableName)) {
            error_log("SettingsModel::setSetting: tableName is empty");
            return false;
        }
        
        // بررسی وجود تنظیمات
        $existing = $this->db->selectOne(
            "SELECT id FROM {$this->tableName} WHERE setting_key = ?",
            [$key]
        );
        
        if ($existing) {
            // به‌روزرسانی
            $data = [
                'setting_value' => $value,
                'updated_by' => $updatedBy
            ];
            return $this->update($existing['id'], $data);
        } else {
            // ایجاد جدید
            $data = [
                'setting_key' => $key,
                'setting_value' => $value,
                'updated_by' => $updatedBy
            ];
            return $this->create($data);
        }
    }
    
    /**
     * دریافت متن درباره ما
     */
    public function getAboutUs() {
        return $this->getSetting('about_us');
    }
    
    /**
     * ذخیره متن درباره ما
     */
    public function setAboutUs($text, $updatedBy = null) {
        return $this->setSetting('about_us', $text, $updatedBy);
    }
}

