<?php
require_once __DIR__ . '/BaseModel.php';

/**
 * مدل اخبار
 */
class NewsModel extends BaseModel {
    protected $tableName = 'news';
    protected $sectionKey = 'news';
    
    /**
     * دریافت اخبار با پیجینیشن
     */
    public function getPaginated($page = 1, $limit = 5) {
        $offset = ($page - 1) * $limit;
        return $this->getAll($limit, $offset);
    }
    
    /**
     * جستجو در اخبار با پیجینیشن
     */
    public function searchPaginated($keyword, $page = 1, $limit = 5) {
        $offset = ($page - 1) * $limit;
        return $this->search($keyword, $limit, $offset);
    }
    
    /**
     * محاسبه تعداد صفحات
     */
    public function getTotalPages($limit = 5) {
        $total = $this->countAll();
        return ceil($total / $limit);
    }
    
    /**
     * محاسبه تعداد صفحات جستجو
     */
    public function getSearchTotalPages($keyword, $limit = 5) {
        $total = $this->countSearch($keyword);
        return ceil($total / $limit);
    }
}
