<?php
require_once __DIR__ . '/BaseModel.php';

/**
 * مدل فرم‌ها
 */
class FormModel extends BaseModel {
    protected $tableName = 'forms';
    protected $sectionKey = 'forms';
    
    /**
     * جستجو در فرم‌ها
     */
    public function search($keyword, $limit = null, $offset = 0) {
        $searchTerm = "%{$keyword}%";
        $query = "SELECT DISTINCT f.* FROM {$this->tableName} f
                  LEFT JOIN content_tags ct ON ct.section = ? AND ct.item_id = f.id
                  WHERE f.title LIKE ? OR f.form_url LIKE ? OR ct.tag LIKE ?
                  ORDER BY f.created_at DESC";
        $params = ['forms', $searchTerm, $searchTerm, $searchTerm];

        if ($limit) {
            $query .= " LIMIT {$limit}";
            if ($offset > 0) {
                $query .= " OFFSET {$offset}";
            }
        }

        return $this->db->select($query, $params);
    }
    
    /**
     * شمارش نتایج جستجو در فرم‌ها
     */
    public function countSearch($keyword) {
        $searchTerm = "%{$keyword}%";
        $query = "SELECT COUNT(DISTINCT f.id) as total FROM {$this->tableName} f
                  LEFT JOIN content_tags ct ON ct.section = ? AND ct.item_id = f.id
                  WHERE f.title LIKE ? OR f.form_url LIKE ? OR ct.tag LIKE ?";
        $result = $this->db->selectOne($query, ['forms', $searchTerm, $searchTerm, $searchTerm]);
        return $result && isset($result['total']) ? (int)$result['total'] : 0;
    }
}
