<?php
require_once __DIR__ . '/BaseModel.php';

/**
 * مدل FAQ
 */
class FaqModel extends BaseModel {
    protected $tableName = 'faqs';
    protected $sectionKey = 'faq';
    
    /**
     * دریافت FAQ ها با پیجینیشن
     */
    public function getPaginated($page = 1, $limit = 5) {
        $offset = ($page - 1) * $limit;
        return $this->getAll($limit, $offset);
    }
    
    /**
     * جستجو در FAQ ها با پیجینیشن
     */
    public function searchPaginated($keyword, $page = 1, $limit = 5) {
        $offset = ($page - 1) * $limit;
        return $this->search($keyword, $limit, $offset);
    }
    
    /**
     * محاسبه تعداد صفحات
     */
    public function getTotalPages($limit = 5) {
        $total = $this->countAll();
        return ceil($total / $limit);
    }
    
    /**
     * محاسبه تعداد صفحات جستجو
     */
    public function getSearchTotalPages($keyword, $limit = 5) {
        $total = $this->countSearch($keyword);
        return ceil($total / $limit);
    }
    
    /**
     * جستجو در سوالات و پاسخ‌ها
     */
    public function search($keyword, $limit = null, $offset = 0) {
        $searchTerm = "%{$keyword}%";
        $query = "SELECT DISTINCT f.* FROM {$this->tableName} f
                  LEFT JOIN content_tags ct ON ct.section = ? AND ct.item_id = f.id
                  WHERE f.question LIKE ? OR f.answer LIKE ? OR ct.tag LIKE ?
                  ORDER BY f.created_at DESC";
        $params = ['faq', $searchTerm, $searchTerm, $searchTerm];
        
        if ($limit) {
            $query .= " LIMIT {$limit}";
            if ($offset > 0) {
                $query .= " OFFSET {$offset}";
            }
        }
        
        return $this->db->select($query, $params);
    }
    
    /**
     * شمارش نتایج جستجو در سوالات و پاسخ‌ها
     */
    public function countSearch($keyword) {
        $searchTerm = "%{$keyword}%";
        $query = "SELECT COUNT(DISTINCT f.id) as total FROM {$this->tableName} f
                  LEFT JOIN content_tags ct ON ct.section = ? AND ct.item_id = f.id
                  WHERE f.question LIKE ? OR f.answer LIKE ? OR ct.tag LIKE ?";
        $result = $this->db->selectOne($query, ['faq', $searchTerm, $searchTerm, $searchTerm]);
        return $result['total'] ?? 0;
    }
}
