<?php
require_once __DIR__ . '/BaseModel.php';

/**
 * مدل جملات اخلاق مهندسی
 */
class EthicModel extends BaseModel {
    protected $tableName = 'ethics_quotes';
    protected $sectionKey = 'ethics';

    /**
     * دریافت یک جمله تصادفی
     */
    public function getRandomQuote() {
        $query = "SELECT * FROM {$this->tableName} ORDER BY RAND() LIMIT 1";
        return $this->db->selectOne($query);
    }

    /**
     * جستجو در جملات
     */
    public function search($keyword, $limit = null, $offset = 0) {
        $searchTerm = "%{$keyword}%";
        $query = "SELECT DISTINCT e.* FROM {$this->tableName} e
                  LEFT JOIN content_tags ct ON ct.section = ? AND ct.item_id = e.id
                  WHERE e.quote_text LIKE ? OR ct.tag LIKE ?
                  ORDER BY e.created_at DESC";
        $params = ['ethics', $searchTerm, $searchTerm];

        if ($limit) {
            $query .= " LIMIT {$limit}";
            if ($offset > 0) {
                $query .= " OFFSET {$offset}";
            }
        }

        return $this->db->select($query, $params);
    }

    /**
     * شمارش نتایج جستجو
     */
    public function countSearch($keyword) {
        $searchTerm = "%{$keyword}%";
        $query = "SELECT COUNT(DISTINCT e.id) as total FROM {$this->tableName} e
                  LEFT JOIN content_tags ct ON ct.section = ? AND ct.item_id = e.id
                  WHERE e.quote_text LIKE ? OR ct.tag LIKE ?";
        $result = $this->db->selectOne($query, ['ethics', $searchTerm, $searchTerm]);
        return $result && isset($result['total']) ? (int)$result['total'] : 0;
    }
}


