<?php
require_once __DIR__ . '/BaseModel.php';

/**
 * مدیریت پیام‌های همگانی
 */
class BroadcastMessageModel extends BaseModel {
    protected $tableName = 'broadcast_messages';

    /**
     * ایجاد پیام همگانی جدید
     */
    public function createMessage($data) {
        return $this->create($data);
    }

    /**
     * به‌روزرسانی وضعیت پیام
     */
    public function updateMessage($id, $data) {
        return $this->update($id, $data);
    }

    /**
     * دریافت پیام‌ها با ترتیب نزولی
     */
    public function getAllMessages($limit = 50) {
        $query = "SELECT * FROM {$this->tableName} ORDER BY created_at DESC";
        if ($limit) {
            $query .= " LIMIT " . (int)$limit;
        }
        return $this->db->select($query);
    }

    /**
     * دریافت پیام بر اساس شناسه
     */
    public function getMessageById($id) {
        return $this->getById($id);
    }
}


