<?php
require_once __DIR__ . '/BaseModel.php';

/**
 * مدل دستیارهای هوشمند
 */
class AiModel extends BaseModel {
    protected $tableName = 'ai';
    protected $sectionKey = 'ai';
    
    /**
     * جستجو در دستیارهای هوشمند
     */
    public function search($keyword, $limit = null, $offset = 0) {
        $searchTerm = "%{$keyword}%";
        $query = "SELECT DISTINCT a.* FROM {$this->tableName} a 
                  LEFT JOIN content_tags ct ON ct.section = ? AND ct.item_id = a.id
                  WHERE a.title LIKE ? OR a.website_url LIKE ? OR ct.tag LIKE ?
                  ORDER BY a.created_at DESC";
        $params = ['ai', $searchTerm, $searchTerm, $searchTerm];
        
        if ($limit) {
            $query .= " LIMIT {$limit}";
            if ($offset > 0) {
                $query .= " OFFSET {$offset}";
            }
        }
        
        return $this->db->select($query, $params);
    }
    
    /**
     * شمارش نتایج جستجو در دستیارهای هوشمند
     */
    public function countSearch($keyword) {
        if (empty($this->tableName)) {
            error_log("AiModel::countSearch: tableName is empty");
            return 0;
        }
        $searchTerm = "%{$keyword}%";
        $query = "SELECT COUNT(DISTINCT a.id) as total FROM {$this->tableName} a 
                  LEFT JOIN content_tags ct ON ct.section = ? AND ct.item_id = a.id
                  WHERE a.title LIKE ? OR a.website_url LIKE ? OR ct.tag LIKE ?";
        $result = $this->db->selectOne($query, ['ai', $searchTerm, $searchTerm, $searchTerm]);
        return $result && isset($result['total']) ? (int)$result['total'] : 0;
    }
}
