<?php

use Exception;

if (php_sapi_name() !== 'cli') {
    exit("CLI only\n");
}

$broadcastId = isset($argv[1]) ? (int)$argv[1] : 0;
if ($broadcastId <= 0) {
    exit("Invalid broadcast id\n");
}

date_default_timezone_set('Asia/Tehran');

require_once __DIR__ . '/../src/Models/AllModels.php';
require_once __DIR__ . '/../src/TelegramBot/TelegramBot.php';

$broadcastModel = new BroadcastMessageModel();
$activityLogModel = new ActivityLogModel();
$bot = new TelegramBot();

$broadcast = $broadcastModel->getById($broadcastId);
if (!$broadcast) {
    exit("Broadcast not found\n");
}

$status = $broadcast['status'] ?? 'pending';
if (!in_array($status, ['pending', 'failed', 'in_progress'], true)) {
    exit("Broadcast already processed\n");
}

$recipients = $activityLogModel->getAllUniqueChatIds();
$recipients = array_filter($recipients, function ($item) {
    return !empty($item['chat_id']);
});
$recipients = array_values($recipients);

$totalRecipients = count($recipients);

$broadcastModel->updateMessage($broadcastId, [
    'status' => 'in_progress',
    'started_at' => date('Y-m-d H:i:s'),
    'total_recipients' => $totalRecipients,
    'sent_success' => 0,
    'sent_failed' => 0,
    'last_error' => null
]);

if ($totalRecipients === 0) {
    $broadcastModel->updateMessage($broadcastId, [
        'status' => 'completed',
        'completed_at' => date('Y-m-d H:i:s'),
        'last_error' => null
    ]);
    exit;
}

$messageText = $broadcast['message_text'] ?? '';
$parseMode = array_key_exists('parse_mode', $broadcast) ? $broadcast['parse_mode'] : 'HTML';
if ($parseMode === null || trim((string)$parseMode) === '' || strtoupper((string)$parseMode) === 'NONE') {
    $parseMode = null;
}

$sentSuccess = 0;
$sentFailed = 0;
$lastError = null;

foreach ($recipients as $index => $recipient) {
    $chatId = $recipient['chat_id'];

    try {
        $result = $bot->sendMessage(
            $chatId,
            $messageText,
            null,
            null,
            true,
            $parseMode
        );

        if ($result && isset($result['ok']) && $result['ok'] === true) {
            $sentSuccess++;
        } else {
            $sentFailed++;
            $lastError = isset($result['description']) ? $result['description'] : 'ارسال ناموفق';
        }
    } catch (Exception $e) {
        $sentFailed++;
        $lastError = $e->getMessage();
    }

    if ((($index + 1) % 10) === 0) {
        $broadcastModel->updateMessage($broadcastId, [
            'sent_success' => $sentSuccess,
            'sent_failed' => $sentFailed
        ]);
    }

    usleep(200000); // 0.2 ثانیه
}

$finalStatus = ($sentFailed === 0) ? 'completed' : (($sentSuccess > 0) ? 'completed' : 'failed');

$updateData = [
    'status' => $finalStatus,
    'sent_success' => $sentSuccess,
    'sent_failed' => $sentFailed,
    'completed_at' => date('Y-m-d H:i:s')
];

if ($lastError) {
    $updateData['last_error'] = mb_substr($lastError, 0, 500);
}

$broadcastModel->updateMessage($broadcastId, $updateData);

exit;


