<?php
/**
 * تنظیمات بات تلگرام
 */

class BotConfig {
    // توکن بات تلگرام - باید از BotFather دریافت کنید
    public const BOT_TOKEN = '8290907226:AAFSEq8bvGxRFqv_64ZO4trSasMtSfF9hx4';
    
    // آدرس وب‌سایت (برای webhook)
    public const WEBHOOK_URL = 'https://qsce.ir/bot/webhook.php';
    
    // آدرس پایه وب‌سایت (برای ساخت لینک دانلود فایل‌ها)
    public const BASE_URL = 'https://qsce.ir';
    
    // تنظیمات عمومی
    public const MAX_RESULTS_PER_PAGE = 5;
    public const SEARCH_RESULTS_LIMIT = 10;
    public const SEARCH_RESULTS_PER_PAGE = 10; // تعداد نتایج در هر صفحه جستجو
    
    // لینک کانال تلگرام
    public const TELEGRAM_CHANNEL = 'https://t.me/qsceir';
    
    // پیام‌های سیستم
    public const MESSAGES = [
        'welcome' => '👋 به بات جامعه مهندسین ساختمان استان قم خوش آمدید',
        'main_menu' => '🏠 منوی اصلی',
        'search' => '🔍 جست و جو',
        'instructions' => '📋 دستورالعمل ها',
        'regulations' => '📜 آیین نامه ها',
        'trainings' => '🎓 آموزش ها',
        'reports' => '📊 گزارش نویسی',
        'news' => '📰 اخبار',
        'faq' => 'FAQ ❓ ',
        'no_results' => '🔍 نتیجه‌ای یافت نشد',
        'page' => '📄 صفحه',
        'of' => 'از',
        'next' => 'بعدی',
        'previous' => 'قبلی',
        'search_placeholder' => 'متن جستجو را وارد کنید...',
        'file_sent' => '✅ فایل برای شما ارسال شد',
        'error_occurred' => '⚠️ خطایی رخ داد. لطفاً دوباره تلاش کنید.',
        'admin_access_denied' => '🚫 شما دسترسی ادمین ندارید',
        'admin_login_success' => '✅ ورود موفقیت‌آمیز',
        'admin_logout_success' => '👋 خروج موفقیت‌آمیز',
        'file_not_found' => '📁 فایل مورد نظر یافت نشد',
        'file_send_error' => '❌ خطا در ارسال فایل',
        'file_no_url' => '📎 فایل برای این مطلب تعریف نشده است',
        'search_in_section' => '🔍 جستجو در',
        'search_results' => '📋 نتایج جستجو',
        'search_for' => 'جستجو برای',
        'global_search' => '🌐 جستجوی عمومی',
        'ai' => '🤖 دستیارهای هوشمند',
        'ethics' => '⚖️ اخلاق مهندسی',
        'forms' => '📝 فرم‌ها',
        'about_us' => 'ℹ️ درباره ما',
        'channel_required_title' => 'برای استفاده از بات باید در کانال عضو شوید.',
        'channel_required_subtitle' => 'کانال رسمی جامعه مهندسین ساختمان قم QSCE',
        'channel_membership_confirmed' => '✅ عضویت شما تایید شد! اکنون می‌توانید از امکانات بات استفاده کنید.',
        'channel_membership_pending' => '❗️ هنوز عضو کانال نیستید. لطفاً ابتدا عضو شوید و دوباره روی دکمه «بررسی عضویت» بزنید.'
    ];
    
    /**
     * دریافت توکن بات
     */
    public static function getBotToken() {
        return self::BOT_TOKEN;
    }
    
    /**
     * دریافت آدرس webhook
     */
    public static function getWebhookUrl() {
        return self::WEBHOOK_URL;
    }
    
    /**
     * دریافت آدرس پایه وب‌سایت
     */
    public static function getBaseUrl() {
        return self::BASE_URL;
    }
    
    /**
     * دریافت پیام بر اساس کلید
     */
    public static function getMessage($key) {
        return self::MESSAGES[$key] ?? $key;
    }
}
