<?php
require_once __DIR__ . '/../src/Bot/BotHandler.php';
require_once __DIR__ . '/../src/Bot/SearchHandler.php';

// دریافت داده‌های webhook
$input = file_get_contents('php://input');
$update = json_decode($input, true);

if (!$update) {
    http_response_code(400);
    exit('Invalid JSON');
}

// لاگ کردن درخواست (اختیاری)
error_log("Webhook received: " . $input);

try {
    $botHandler = new BotHandler();
    $searchHandler = new SearchHandler();
    
    // بررسی نوع پیام
    if (isset($update['message'])) {
        $message = $update['message'];
        $chatId = $message['chat']['id'];
        $text = $message['text'] ?? '';
        
        // بررسی دستورات خاص
        if ($text === '/start') {
            $botHandler->handleUpdate($update);
        } elseif ($text === '/help') {
            $botHandler->handleUpdate($update);
        } elseif ($searchHandler->hasSearchSession($chatId)) {
            // پردازش جستجو
            $searchHandler->processSearch($chatId, $text);
        } else {
            // جستجوی عمومی - اجازه جستجوی کلمات یک حرفی و دو حرفی
            $trimmedText = trim($text);
            if (!empty($trimmedText) && mb_strlen($trimmedText) >= 1) {
                $searchHandler->globalSearch($chatId, $trimmedText);
            }
            // اگر متن خالی است یا دستور خاصی نیست، هیچ پیامی ارسال نمی‌کنیم
            // تا از ارسال پیام‌های تکراری جلوگیری شود
        }
    } elseif (isset($update['callback_query'])) {
        $callbackQuery = $update['callback_query'];
        $data = $callbackQuery['data'];
        
        // بررسی نوع callback
        if (strpos($data, 'search_') === 0) {
            if (strpos($data, '_page_') !== false) {
                $messageText = $callbackQuery['message']['text'] ?? '';
                $searchHandler->handleSearchPagination($callbackQuery['message']['chat']['id'], $callbackQuery['message']['message_id'], $data, $messageText);
            } else {
                $searchHandler->handleSearch($callbackQuery['message']['chat']['id'], $callbackQuery['message']['message_id'], $data);
            }
        } else {
            $botHandler->handleUpdate($update);
        }
    }
    
    // پاسخ موفق
    http_response_code(200);
    echo 'OK';
    
} catch (Exception $e) {
    error_log("Bot error: " . $e->getMessage());
    http_response_code(500);
    echo 'Error';
}
?>
