<?php
require_once __DIR__ . '/../src/TelegramBot/TelegramBot.php';
require_once __DIR__ . '/../config/bot.php';

/**
 * فایل تنظیم webhook و اطلاعات بات
 */

$bot = new TelegramBot();

// دریافت اطلاعات بات
echo "<h2>اطلاعات بات</h2>";
$me = $bot->getMe();
if ($me) {
    echo "<pre>" . json_encode($me, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
} else {
    echo "<p style='color: red;'>خطا در دریافت اطلاعات بات. لطفاً توکن را بررسی کنید.</p>";
}

echo "<hr>";

// تنظیم webhook
echo "<h2>تنظیم Webhook</h2>";
$webhookUrl = BotConfig::getWebhookUrl();
echo "<p>آدرس Webhook: <strong>{$webhookUrl}</strong></p>";

$setWebhook = $bot->setWebhook($webhookUrl);
if ($setWebhook) {
    echo "<p style='color: green;'>✅ Webhook با موفقیت تنظیم شد.</p>";
} else {
    echo "<p style='color: red;'>❌ خطا در تنظیم Webhook.</p>";
}

echo "<hr>";

// دریافت اطلاعات webhook
echo "<h2>اطلاعات Webhook</h2>";
$webhookInfo = $bot->getWebhookInfo();
if ($webhookInfo) {
    echo "<pre>" . json_encode($webhookInfo, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
} else {
    echo "<p style='color: red;'>خطا در دریافت اطلاعات Webhook.</p>";
}

echo "<hr>";

// دستورات مفید
echo "<h2>دستورات مفید</h2>";
echo "<ul>";
echo "<li><strong>حذف Webhook:</strong> <code>DELETE</code> درخواست به <code>https://api.telegram.org/bot" . BotConfig::getBotToken() . "/deleteWebhook</code></li>";
echo "<li><strong>تست بات:</strong> پیام <code>/start</code> به بات ارسال کنید</li>";
echo "<li><strong>پنل ادمین:</strong> <a href='../admin/'>../admin/</a></li>";
echo "</ul>";

echo "<hr>";
echo "<p><strong>نکته:</strong> قبل از استفاده، حتماً توکن بات را در فایل <code>config/bot.php</code> تنظیم کنید.</p>";
?>
