<?php
require_once __DIR__ . '/auth.php';

// اگر کاربر لاگین کرده، هدایت به صفحه اصلی
if (isLoggedIn()) {
    header('Location: index.php');
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if (empty($username) || empty($password)) {
        $error = 'لطفاً همه فیلدها را پر کنید';
    } else {
        if (login($username, $password)) {
            header('Location: index.php');
            exit;
        } else {
            $error = 'نام کاربری یا رمز عبور اشتباه است';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ورود به پنل مدیریت</title>
    <link rel="icon" type="image/png" href="../image/bot.png">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazir-font@v30.1.0/dist/font-face.css" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Vazir', 'Tahoma', sans-serif;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow: hidden;
            background: #0a0e27;
        }
        /* گرادیان متحرک */
        .animated-gradient {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(-45deg, #667eea, #764ba2, #f093fb, #4facfe, #667eea);
            background-size: 400% 400%;
            animation: gradientShift 15s ease infinite;
            opacity: 0.85;
        }
        @keyframes gradientShift {
            0% { 
                background-position: 0% 50%;
                opacity: 0.85;
            }
            25% {
                background-position: 100% 50%;
                opacity: 0.9;
            }
            50% { 
                background-position: 100% 100%;
                opacity: 0.85;
            }
            75% {
                background-position: 0% 100%;
                opacity: 0.9;
            }
            100% { 
                background-position: 0% 50%;
                opacity: 0.85;
            }
        }
        .particles {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            overflow: hidden;
        }
        .particle {
            position: absolute;
            background: rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            animation: floatAndFade 15s infinite ease-in-out;
        }
        @keyframes floatAndFade {
            0% { transform: translateY(0) translateX(0) scale(1); opacity: 0.8; }
            25% { transform: translateY(-20px) translateX(10px) scale(1.1); opacity: 0.6; }
            50% { transform: translateY(-40px) translateX(-10px) scale(1.2); opacity: 0.4; }
            75% { transform: translateY(-20px) translateX(10px) scale(1.1); opacity: 0.2; }
            100% { transform: translateY(0) translateX(0) scale(1); opacity: 0; }
        }
        .login-container {
            position: relative;
            z-index: 10;
        }
        .login-card {
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border-radius: 20px;
            border: 1px solid rgba(255, 255, 255, 0.3);
            box-shadow: 0 25px 60px rgba(15, 23, 42, 0.2);
            overflow: hidden;
            max-width: 700px;
            width: 100%;
            margin: 20px;
        }
        .login-header {
            background: linear-gradient(135deg, #4f46e5 0%, #6366f1 100%);
            color: white;
            padding: 2rem;
            text-align: center;
        }
        .login-body {
            padding: 2rem;
        }
        /* ریسپانسیو برای موبایل */
        @media (max-width: 768px) {
            body {
                padding: 10px;
                overflow-x: hidden;
            }
            .login-container {
                width: 100%;
                max-width: 100%;
            }
            .login-card {
                width: 100%;
                max-width: 100%;
                margin: 10px;
                border-radius: 15px;
            }
            .login-header {
                padding: 1.5rem 1rem;
            }
            .login-header img {
                width: 60px !important;
                height: 60px !important;
            }
            .login-header h3 {
                font-size: 1.2rem;
            }
            .login-body {
                padding: 1.5rem 1rem;
            }
            .form-control {
                padding: 10px 12px;
                font-size: 16px; /* جلوگیری از zoom در iOS */
            }
            .btn-login {
                padding: 12px 20px;
                font-size: 1rem;
            }
            .animated-gradient {
                background-size: 300% 300%; /* کاهش اندازه برای عملکرد بهتر در موبایل */
            }
            .particles {
                display: none; /* غیرفعال کردن پارتیکل‌ها در موبایل برای عملکرد بهتر */
            }
        }
        @media (max-width: 480px) {
            .login-header {
                padding: 1rem;
            }
            .login-header img {
                width: 50px !important;
                height: 50px !important;
            }
            .login-header h3 {
                font-size: 1rem;
            }
            .login-body {
                padding: 1rem;
            }
        }
        .form-control {
            border-radius: 10px;
            border: 2px solid #e5e7eb;
            padding: 12px 15px;
        }
        .form-control:focus {
            border-color: #4f46e5;
            box-shadow: 0 0 0 0.2rem rgba(79, 70, 229, 0.2);
        }
        .btn-login {
            background: linear-gradient(135deg, #4f46e5 0%, #6366f1 100%);
            border: none;
            border-radius: 10px;
            padding: 15px 30px;
            font-weight: bold;
            width: 100%;
            font-size: 1.1rem;
        }
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        .alert {
            border-radius: 10px;
        }
    </style>
</head>
<body>
    <div class="animated-gradient"></div>
    <div class="particles" id="particles"></div>
    <div class="login-container">
    <div class="login-card">
        <div class="login-header">
            <img src="../image/bot.png" alt="Bot" style="width: 80px; height: 80px; margin-bottom: 1rem; border-radius: 50%; border: 3px solid rgba(255,255,255,0.3);">
            <h3>پنل مدیریت بات QSCE</h3>
        </div>
        <div class="login-body">
            <?php if ($error): ?>
                <div class="alert alert-danger" role="alert">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <?php echo $error; ?>
                </div>
            <?php endif; ?>
            
            <form method="POST">
                <div class="mb-3">
                    <label for="username" class="form-label">
                        <i class="fas fa-user me-2" style="margin-left: 0.5rem;"></i>نام کاربری
                    </label>
                    <input type="text" class="form-control" id="username" name="username" 
                           value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>" required>
                </div>
                
                <div class="mb-4">
                    <label for="password" class="form-label">
                        <i class="fas fa-lock me-2" style="margin-left: 0.5rem;"></i>رمز عبور
                    </label>
                    <input type="password" class="form-control" id="password" name="password" required>
                </div>
                
                <button type="submit" class="btn btn-primary btn-login">
                    <i class="fas fa-sign-in-alt me-2" style="margin-left: 0.5rem;"></i>ورود
                </button>
            </form>
        </div>
    </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // ایجاد پارتیکل‌ها
        function createParticles() {
            const particlesContainer = document.getElementById('particles');
            const particleCount = 50;
            
            for (let i = 0; i < particleCount; i++) {
                const particle = document.createElement('div');
                particle.className = 'particle';
                
                const size = Math.random() * 5 + 2;
                particle.style.width = size + 'px';
                particle.style.height = size + 'px';
                particle.style.left = Math.random() * 100 + '%';
                particle.style.top = Math.random() * 100 + '%';
                particle.style.animationDelay = Math.random() * 20 + 's';
                particle.style.animationDuration = (Math.random() * 10 + 15) + 's';
                
                particlesContainer.appendChild(particle);
            }
        }
        
        createParticles();
    </script>
</body>
</html>
