<?php
header('Content-Type: application/json; charset=utf-8');

// استفاده از کتابخانه PersianCalendar
$persianCalendarPath = __DIR__ . '/PersianCalneder';
if (file_exists($persianCalendarPath . '/Jalalian.php') && file_exists($persianCalendarPath . '/CalendarUtils.php')) {
    // بررسی autoloader
    $vendorPath = __DIR__ . '/../../vendor/autoload.php';
    if (file_exists($vendorPath)) {
        require_once $vendorPath;
    } else {
        // لود دستی کلاس‌ها
        require_once $persianCalendarPath . '/CalendarUtils.php';
        require_once $persianCalendarPath . '/Converter.php';
        require_once $persianCalendarPath . '/Jalalian.php';
    }
    
    try {
        if (class_exists('Morilog\Jalali\Jalalian')) {
            $jalali = \Morilog\Jalali\Jalalian::now();
            $persianDate = $jalali->format('Y/m/d');
        } else {
            throw new Exception('Jalalian class not found');
        }
    } catch (Exception $e) {
        error_log("Error getting Persian date: " . $e->getMessage());
        // Fallback به date_helper
        require_once __DIR__ . '/date_helper.php';
        $today = new DateTime('now', new DateTimeZone('Asia/Tehran'));
        $persianDate = toJalali($today->format('Y-m-d H:i:s'), 'Y/m/d');
    }
} else {
    // Fallback به date_helper
    require_once __DIR__ . '/date_helper.php';
    $today = new DateTime('now', new DateTimeZone('Asia/Tehran'));
    $persianDate = toJalali($today->format('Y-m-d H:i:s'), 'Y/m/d');
}

echo json_encode([
    'success' => true,
    'date' => $persianDate
], JSON_UNESCAPED_UNICODE);

