<?php
session_start();
require_once __DIR__ . '/../src/Database/Database.php';
require_once __DIR__ . '/../src/Models/InstructionModel.php';

// بررسی ورود کاربر
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

$success = '';
$error = '';

// پردازش درخواست‌ها
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    try {
        $model = new InstructionModel();
        
        switch ($action) {
            case 'add':
                $result = $model->create([
                    'title' => $_POST['title'],
                    'description' => $_POST['description'],
                    'file_url' => $_POST['file_url']
                ]);
                
                if ($result) {
                    $success = "آیتم با موفقیت اضافه شد (ID: {$result})";
                } else {
                    $error = "خطا در افزودن آیتم";
                }
                break;
                
            case 'edit':
                $id = $_POST['id'];
                $result = $model->update($id, [
                    'title' => $_POST['title'],
                    'description' => $_POST['description'],
                    'file_url' => $_POST['file_url']
                ]);
                
                if ($result) {
                    $success = "آیتم با موفقیت ویرایش شد";
                } else {
                    $error = "خطا در ویرایش آیتم";
                }
                break;
                
            case 'delete':
                $id = $_POST['id'];
                $result = $model->delete($id);
                
                if ($result) {
                    $success = "آیتم با موفقیت حذف شد";
                } else {
                    $error = "خطا در حذف آیتم";
                }
                break;
        }
    } catch (Exception $e) {
        $error = "خطا: " . $e->getMessage();
    }
}

// دریافت آیتم‌ها
$model = new InstructionModel();
$items = $model->getAll();
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تست کامل پنل ادمین</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { font-family: Tahoma; margin: 20px; }
    </style>
</head>
<body>
    <div class="container">
        <h2>تست کامل پنل ادمین - دستورالعمل‌ها</h2>
        
        <?php if ($success): ?>
            <div class="alert alert-success"><?php echo $success; ?></div>
        <?php endif; ?>
        
        <?php if ($error): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <!-- فرم افزودن -->
        <div class="card mb-4">
            <div class="card-header">
                <h5>افزودن آیتم جدید</h5>
            </div>
            <div class="card-body">
                <form method="POST">
                    <input type="hidden" name="action" value="add">
                    <div class="mb-3">
                        <label for="title" class="form-label">عنوان:</label>
                        <input type="text" class="form-control" id="title" name="title" required>
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label">توضیحات:</label>
                        <textarea class="form-control" id="description" name="description" rows="3"></textarea>
                    </div>
                    <div class="mb-3">
                        <label for="file_url" class="form-label">لینک فایل:</label>
                        <input type="url" class="form-control" id="file_url" name="file_url">
                    </div>
                    <button type="submit" class="btn btn-primary">افزودن</button>
                </form>
            </div>
        </div>
        
        <!-- لیست آیتم‌ها -->
        <div class="card">
            <div class="card-header">
                <h5>لیست آیتم‌ها</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>عنوان</th>
                                <th>توضیحات</th>
                                <th>لینک فایل</th>
                                <th>تاریخ ایجاد</th>
                                <th>عملیات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($items as $item): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($item['title']); ?></td>
                                    <td><?php echo htmlspecialchars(substr($item['description'], 0, 100)) . '...'; ?></td>
                                    <td>
                                        <?php if ($item['file_url']): ?>
                                            <span class="text-success">✅ تعریف شده</span>
                                            <br><small class="text-muted"><?php echo htmlspecialchars(substr($item['file_url'], 0, 50)) . '...'; ?></small>
                                        <?php else: ?>
                                            <span class="text-muted">❌ تعریف نشده</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo date('Y/m/d H:i', strtotime($item['created_at'])); ?></td>
                                    <td>
                                        <button class="btn btn-sm btn-warning me-1" onclick="editItem(<?php echo $item['id']; ?>)">
                                            ویرایش
                                        </button>
                                        <form method="POST" style="display: inline;">
                                            <input type="hidden" name="action" value="delete">
                                            <input type="hidden" name="id" value="<?php echo $item['id']; ?>">
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('آیا مطمئن هستید؟')">
                                                حذف
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        
        <hr>
        <p><a href="index.php" class="btn btn-secondary">بازگشت به پنل اصلی</a></p>
    </div>
    
    <script>
        function editItem(id) {
            // اینجا می‌توانید فرم ویرایش را نمایش دهید
            alert('ویرایش آیتم ' + id);
        }
    </script>
</body>
</html>
