<?php
/**
 * فایل احراز هویت و کنترل دسترسی
 */
session_start();

require_once __DIR__ . '/../src/Models/AdminModel.php';

/**
 * بررسی ورود کاربر
 */
function isLoggedIn() {
    return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
}

/**
 * دریافت اطلاعات کاربر فعلی
 */
function getCurrentUser() {
    if (isset($_SESSION['admin_id'])) {
        $adminModel = new AdminModel();
        return $adminModel->getById($_SESSION['admin_id']);
    }
    return null;
}

/**
 * بررسی نقش کاربر
 */
function getUserRole() {
    $user = getCurrentUser();
    return $user ? $user['role'] : null;
}

/**
 * بررسی دسترسی برای ویرایش/حذف مطلب
 */
function canModifyContent($contentCreatorId) {
    $user = getCurrentUser();
    if (!$user) {
        return false;
    }
    
    $adminModel = new AdminModel();
    return $adminModel->canModifyContent($user['id'], $contentCreatorId, $user['role']);
}

/**
 * بررسی دسترسی مدیریت ادمین‌ها
 */
function canManageAdmins() {
    $user = getCurrentUser();
    if (!$user) {
        return false;
    }
    
    $adminModel = new AdminModel();
    return $adminModel->canManageAdmins($user['role']);
}

/**
 * درخواست ورود
 */
function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: login.php');
        exit;
    }
}

/**
 * درخواست ورود (نام مستعار)
 */
function require_login() {
    requireLogin();
}

/**
 * درخواست نقش خاص
 */
function requireRole($requiredRole) {
    requireLogin();
    
    $userRole = getUserRole();
    if ($userRole !== $requiredRole) {
        header('Location: index.php?error=permission_denied');
        exit;
    }
}

/**
 * درخواست سوپر ادمین
 */
function requireSuperAdmin() {
    requireRole('super_admin');
}

/**
 * ورود کاربر
 */
function login($username, $password) {
    $adminModel = new AdminModel();
    $user = $adminModel->authenticate($username, $password);
    
    if ($user) {
        $_SESSION['admin_logged_in'] = true;
        $_SESSION['admin_id'] = $user['id'];
        $_SESSION['admin_username'] = $user['username'];
        $_SESSION['admin_role'] = $user['role'];
        $_SESSION['admin_full_name'] = $user['full_name'];
        
        // ثبت لاگ
        logAction('login', "ورود به سیستم");
        
        return true;
    }
    
    return false;
}

/**
 * خروج کاربر
 */
function logout() {
    if (isLoggedIn()) {
        logAction('logout', "خروج از سیستم");
    }
    
    session_destroy();
    header('Location: login.php');
    exit;
}

/**
 * ثبت لاگ
 */
function logAction($action, $description) {
    // اگر جدول system_logs وجود ندارد، هیچ کاری انجام نمی‌دهیم
    // این تابع اختیاری است و نباید خطا ایجاد کند
    try {
        require_once __DIR__ . '/../src/Database/Database.php';
        
        $db = new Database();
        $user_id = $_SESSION['admin_id'] ?? null;
        $ip_address = $_SERVER['REMOTE_ADDR'] ?? '';
        
        // بررسی وجود جدول قبل از insert
        $checkQuery = "SHOW TABLES LIKE 'system_logs'";
        $result = $db->select($checkQuery);
        
        if (!empty($result)) {
            $query = "INSERT INTO system_logs (user_id, action, description, ip_address) VALUES (?, ?, ?, ?)";
            $db->insert($query, [$user_id, $action, $description, $ip_address]);
        }
    } catch (Exception $e) {
        // خطا را نادیده می‌گیریم چون logAction اختیاری است
    }
}