<?php
require_once __DIR__ . '/auth.php';
require_login();
$currentUser = getCurrentUser();

require_once __DIR__ . '/../src/Models/ActivityLogModel.php';
require_once __DIR__ . '/../src/Models/BotUserModel.php';
require_once __DIR__ . '/helpers/date_helper.php';

$activityLogModel = new ActivityLogModel();
$botUserModel = new BotUserModel();

// دریافت آمار
$summaryStats = $activityLogModel->getSummaryStats();
$buttonClickStats = $activityLogModel->getButtonClickStats(15);
$sectionStats = $activityLogModel->getSectionStats(15);
$fileViewStats = $activityLogModel->getFileViewStats(20);
// استفاده از BotUserModel برای دریافت کاربران فعال
$activeUsersStats = $botUserModel->getAllUsers(30, 0, 'activity_count DESC, last_seen_at DESC');
$dailyStats = $activityLogModel->getDailyStats(30);
$hourlyStats = $activityLogModel->getHourlyStats(7);
$userStats = $botUserModel->getUserStats();

// دریافت لاگ‌های اخیر
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = 50;
$offset = ($page - 1) * $limit;
$filters = [];

if (isset($_GET['chat_id']) && !empty($_GET['chat_id'])) {
    $filters['chat_id'] = (int)$_GET['chat_id'];
}
if (isset($_GET['action_type']) && !empty($_GET['action_type'])) {
    $filters['action_type'] = $_GET['action_type'];
}
if (isset($_GET['section']) && !empty($_GET['section'])) {
    $filters['section'] = $_GET['section'];
}

$logs = $activityLogModel->getAllLogs($limit, $offset, $filters);
$totalLogs = $activityLogModel->getTotalLogs($filters);
$totalPages = ceil($totalLogs / $limit);

?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>آمار و آنالیز - QSCE</title>
    <link rel="icon" type="image/png" href="../image/bot.png">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazir-font@v30.1.0/dist/font-face.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.js"></script>
    <style>
        body {
            background: #f5f7fb;
            font-family: 'Vazir', 'Tahoma', sans-serif;
            color: #111827;
        }
        a {
            text-decoration: none;
        }
        .sidebar {
            background: #ffffff;
            min-height: 100vh;
            color: #1f2937;
            border-left: 1px solid #e5e7eb;
            box-shadow: 4px 0 24px rgba(15, 23, 42, 0.04);
        }
        .sidebar-header {
            color: #1f2937;
        }
        .sidebar-header i {
            color: #4f46e5;
        }
        .sidebar .nav {
            padding: 0 1.25rem 2rem;
        }
        .sidebar .nav-link {
            color: #4b5563;
            padding: 12px 18px;
            border-left: 3px solid transparent;
            border-radius: 12px;
            transition: all 0.25s ease;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 0.75rem;
            margin-bottom: 0.35rem;
        }
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            background: rgba(99, 102, 241, 0.1);
            color: #4338ca;
            border-left-color: #4f46e5;
            box-shadow: inset 0 0 0 1px rgba(79, 70, 229, 0.08);
        }
        .sidebar .nav-link i {
            font-size: 1rem;
        }
        .sidebar hr {
            opacity: 1;
            border-top: 1px solid #e5e7eb;
        }
        .stat-card {
            background: #ffffff;
            border-radius: 18px;
            padding: 24px;
            box-shadow: 0 20px 45px rgba(15, 23, 42, 0.08);
            margin-bottom: 20px;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .stat-card:hover {
            transform: translateY(-6px);
            box-shadow: 0 24px 60px rgba(79, 70, 229, 0.12);
        }
        .stat-card h5 {
            color: #4f46e5;
            margin-bottom: 15px;
        }
        .chart-container {
            position: relative;
            height: 300px;
            margin-top: 20px;
        }
        .table-responsive {
            background: white;
            border-radius: 18px;
            padding: 20px;
            box-shadow: 0 16px 35px rgba(15, 23, 42, 0.08);
        }
        .jalali-datetime {
            display: inline-flex;
            align-items: center;
            gap: 0.6rem;
            direction: rtl;
        }
        .jalali-datetime .jalali-date {
            font-weight: 600;
            color: #111827;
        }
        .jalali-datetime .jalali-time {
            font-size: 0.9rem;
            color: #6b7280;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-2 sidebar px-0">
                <div class="text-center py-4 sidebar-header">
                    <i class="fas fa-robot fa-3x mb-3"></i>
                    <h4 style="font-size: 0.95rem;">پنل مدیریت QSCE</h4>
                    <h5 style="font-size: 1.1rem; font-weight: bold;">آمار و آنالیز</h5>
                    <p class="small mb-2" style="font-size: 0.85rem;"><?php echo htmlspecialchars($currentUser['full_name']); ?></p>
                </div>
                <nav class="nav flex-column">
                    <a class="nav-link" href="index.php">
                        <i class="fas fa-home"></i> داشبورد
                    </a>
                    <a class="nav-link active" href="analytics.php">
                        <i class="fas fa-chart-bar"></i> آمار و آنالیز
                    </a>
                    <hr class="my-3">
                    <a class="nav-link" href="logout.php">
                        <i class="fas fa-sign-out-alt"></i> خروج
                    </a>
                </nav>
            </div>
            
            <!-- Content -->
            <div class="col-md-10 p-4">
                <h2 class="mb-4"><i class="fas fa-chart-bar me-2"></i>آمار و آنالیز بات</h2>
                
                <!-- آمار کلی -->
                <div class="stat-card mb-4">
                    <h5><i class="fas fa-chart-line me-2"></i>آمار کلی</h5>
                    <div class="row row-cols-2 row-cols-md-4 g-4 text-center">
                        <div class="col">
                            <div class="display-6 text-primary mb-2"><?php echo number_format($summaryStats['total_activities'] ?? 0); ?></div>
                            <div class="text-muted">کل فعالیت‌ها</div>
                        </div>
                        <div class="col">
                            <div class="display-6 text-success mb-2"><?php echo number_format($summaryStats['total_users'] ?? 0); ?></div>
                            <div class="text-muted">کل کاربران منحصر به فرد</div>
                        </div>
                        <div class="col">
                            <div class="display-6 text-info mb-2"><?php echo number_format($summaryStats['activities_today'] ?? 0); ?></div>
                            <div class="text-muted">فعالیت‌های امروز</div>
                        </div>
                        <div class="col">
                            <div class="display-6 text-danger mb-2"><?php echo number_format($summaryStats['active_users_today'] ?? 0); ?></div>
                            <div class="text-muted">کاربران فعال امروز</div>
                        </div>
                        <div class="col">
                            <div class="display-6 text-primary mb-2"><?php echo number_format($summaryStats['activities_last_7_days'] ?? 0); ?></div>
                            <div class="text-muted">فعالیت‌های ۷ روز گذشته</div>
                        </div>
                        <div class="col">
                            <div class="display-6 text-success mb-2"><?php echo number_format($summaryStats['active_users_last_7_days'] ?? 0); ?></div>
                            <div class="text-muted">کاربران فعال ۷ روز گذشته</div>
                        </div>
                        <div class="col">
                            <div class="display-6 text-info mb-2"><?php echo number_format($summaryStats['total_button_clicks'] ?? 0); ?></div>
                            <div class="text-muted">تعداد کلیک روی دکمه‌ها</div>
                        </div>
                        <div class="col">
                            <div class="display-6 text-secondary mb-2"><?php echo number_format($summaryStats['total_section_views'] ?? 0); ?></div>
                            <div class="text-muted">مشاهده بخش‌ها</div>
                        </div>
                        <div class="col">
                            <div class="display-6 text-warning mb-2"><?php echo number_format($summaryStats['total_file_views'] ?? 0); ?></div>
                            <div class="text-muted">مشاهده فایل‌ها</div>
                        </div>
                    </div>
                </div>
                
                <!-- آمار کلیک روی دکمه‌ها -->
                <div class="stat-card">
                    <h5><i class="fas fa-mouse-pointer me-2"></i>آمار کلیک روی دکمه‌ها</h5>
                    <div class="chart-container">
                        <canvas id="buttonClickChart"></canvas>
                    </div>
                </div>
                
                <!-- آمار استفاده از بخش‌ها -->
                <div class="stat-card">
                    <h5><i class="fas fa-folder me-2"></i>آمار استفاده از بخش‌ها</h5>
                    <div class="chart-container">
                        <canvas id="sectionChart"></canvas>
                    </div>
                </div>
                
                <!-- آمار فعالیت روزانه -->
                <div class="stat-card">
                    <h5><i class="fas fa-calendar-day me-2"></i>آمار فعالیت روزانه (30 روز گذشته)</h5>
                    <div class="chart-container">
                        <canvas id="dailyChart"></canvas>
                    </div>
                </div>
                
                <!-- آمار فعالیت ساعتی -->
                <div class="stat-card">
                    <h5><i class="fas fa-clock me-2"></i>آمار فعالیت ساعتی (7 روز گذشته)</h5>
                    <div class="chart-container">
                        <canvas id="hourlyChart"></canvas>
                    </div>
                </div>
                
                <!-- جدول کاربران فعال -->
                <div class="stat-card">
                    <h5><i class="fas fa-users me-2"></i>کاربران فعال</h5>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>نام کاربری</th>
                                    <th>نام</th>
                                    <th>تعداد فعالیت</th>
                                    <th>آخرین فعالیت</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($activeUsersStats as $user): ?>
                                    <tr>
                                        <td>
                                            <?php if (!empty($user['username'])): ?>
                                                <i class="fas fa-at me-1 text-muted"></i>
                                                <?php echo htmlspecialchars($user['username']); ?>
                                            <?php else: ?>
                                                <span class="text-muted">—</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php 
                                            $fullName = trim(($user['first_name'] ?? '') . ' ' . ($user['last_name'] ?? ''));
                                            echo !empty($fullName) ? htmlspecialchars($fullName) : '<span class="text-muted">نامشخص</span>';
                                            ?>
                                        </td>
                                        <td><span class="badge bg-primary"><?php echo number_format($user['activity_count'] ?? 0); ?></span></td>
                                        <td><?php echo formatDateTimeHtml($user['last_seen_at'] ?? $user['last_activity'] ?? ''); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <!-- جدول پربازدیدترین فایل‌ها -->
                <div class="stat-card">
                    <h5><i class="fas fa-file me-2"></i>پربازدیدترین فایل‌ها</h5>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>عنوان</th>
                                    <th>بخش</th>
                                    <th>تعداد بازدید</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($fileViewStats as $file): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($file['item_title']); ?></td>
                                        <td><span class="badge bg-info"><?php echo htmlspecialchars($file['section']); ?></span></td>
                                        <td><span class="badge bg-success"><?php echo $file['view_count']; ?></span></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <!-- جدول لاگ‌های اخیر -->
                <div class="stat-card">
                    <h5><i class="fas fa-list me-2"></i>لاگ‌های اخیر</h5>
                    <div class="mb-3">
                        <form method="GET" class="row g-3">
                            <div class="col-md-3">
                                <input type="text" class="form-control" name="chat_id" placeholder="شناسه چت" value="<?php echo $_GET['chat_id'] ?? ''; ?>">
                            </div>
                            <div class="col-md-3">
                                <select class="form-control" name="action_type">
                                    <option value="">همه فعالیت‌ها</option>
                                    <option value="button_click" <?php echo ($_GET['action_type'] ?? '') === 'button_click' ? 'selected' : ''; ?>>کلیک روی دکمه</option>
                                    <option value="file_view" <?php echo ($_GET['action_type'] ?? '') === 'file_view' ? 'selected' : ''; ?>>مشاهده فایل</option>
                                    <option value="section_view" <?php echo ($_GET['action_type'] ?? '') === 'section_view' ? 'selected' : ''; ?>>مشاهده بخش</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <select class="form-control" name="section">
                                    <option value="">همه بخش‌ها</option>
                                    <option value="instructions" <?php echo ($_GET['section'] ?? '') === 'instructions' ? 'selected' : ''; ?>>دستورالعمل‌ها</option>
                                    <option value="regulations" <?php echo ($_GET['section'] ?? '') === 'regulations' ? 'selected' : ''; ?>>آیین‌نامه‌ها</option>
                                    <option value="trainings" <?php echo ($_GET['section'] ?? '') === 'trainings' ? 'selected' : ''; ?>>آموزش‌ها</option>
                                    <option value="reports" <?php echo ($_GET['section'] ?? '') === 'reports' ? 'selected' : ''; ?>>گزارش‌نویسی</option>
                                    <option value="news" <?php echo ($_GET['section'] ?? '') === 'news' ? 'selected' : ''; ?>>اخبار</option>
                                    <option value="faq" <?php echo ($_GET['section'] ?? '') === 'faq' ? 'selected' : ''; ?>>سوالات متداول</option>
                                    <option value="ai" <?php echo ($_GET['section'] ?? '') === 'ai' ? 'selected' : ''; ?>>دستیارهای هوشمند</option>
                                    <option value="forms" <?php echo ($_GET['section'] ?? '') === 'forms' ? 'selected' : ''; ?>>فرم‌ها</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <button type="submit" class="btn btn-primary">فیلتر</button>
                                <a href="analytics.php" class="btn btn-secondary">پاک کردن</a>
                            </div>
                        </form>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>نام کاربری</th>
                                    <th>نام</th>
                                    <th>نوع فعالیت</th>
                                    <th>بخش</th>
                                    <th>عنوان</th>
                                    <th>زمان</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($logs as $log): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($log['username'] ?? '-'); ?></td>
                                        <td><?php echo htmlspecialchars(($log['first_name'] ?? '') . ' ' . ($log['last_name'] ?? '')); ?></td>
                                        <td><span class="badge bg-info"><?php echo htmlspecialchars($log['action_type']); ?></span></td>
                                        <td><?php echo htmlspecialchars($log['section'] ?? '-'); ?></td>
                                        <td><?php echo htmlspecialchars($log['item_title'] ?? $log['action_name'] ?? '-'); ?></td>
                                        <td><?php echo formatDateTimeHtml($log['created_at'], true); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php if ($totalPages > 1): 
                        // Pagination هوشمند: حداکثر 10 دکمه
                        $maxButtons = 10;
                        $startPage = 1;
                        $endPage = $totalPages;
                        
                        if ($totalPages > $maxButtons) {
                            // محاسبه محدوده صفحات برای نمایش
                            $halfRange = floor($maxButtons / 2);
                            
                            if ($page <= $halfRange + 1) {
                                // نزدیک به ابتدا
                                $startPage = 1;
                                $endPage = $maxButtons;
                            } elseif ($page >= $totalPages - $halfRange) {
                                // نزدیک به انتها
                                $startPage = $totalPages - $maxButtons + 1;
                                $endPage = $totalPages;
                            } else {
                                // در وسط
                                $startPage = $page - $halfRange;
                                $endPage = $page + $halfRange;
                            }
                        }
                        
                        $queryString = !empty($filters) ? '&' . http_build_query($filters) : '';
                    ?>
                        <nav>
                            <ul class="pagination justify-content-center flex-wrap">
                                <?php if ($page > 1): ?>
                                    <li class="page-item">
                                        <a class="page-link" href="?page=<?php echo $page - 1; ?><?php echo $queryString; ?>" aria-label="قبلی">
                                            <span aria-hidden="true">&laquo;</span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                
                                <?php if ($startPage > 1): ?>
                                    <li class="page-item">
                                        <a class="page-link" href="?page=1<?php echo $queryString; ?>">1</a>
                                    </li>
                                    <?php if ($startPage > 2): ?>
                                        <li class="page-item disabled">
                                            <span class="page-link">...</span>
                                        </li>
                                    <?php endif; ?>
                                <?php endif; ?>
                                
                                <?php for ($i = $startPage; $i <= $endPage; $i++): ?>
                                    <li class="page-item <?php echo $i === $page ? 'active' : ''; ?>">
                                        <a class="page-link" href="?page=<?php echo $i; ?><?php echo $queryString; ?>"><?php echo $i; ?></a>
                                    </li>
                                <?php endfor; ?>
                                
                                <?php if ($endPage < $totalPages): ?>
                                    <?php if ($endPage < $totalPages - 1): ?>
                                        <li class="page-item disabled">
                                            <span class="page-link">...</span>
                                        </li>
                                    <?php endif; ?>
                                    <li class="page-item">
                                        <a class="page-link" href="?page=<?php echo $totalPages; ?><?php echo $queryString; ?>"><?php echo $totalPages; ?></a>
                                    </li>
                                <?php endif; ?>
                                
                                <?php if ($page < $totalPages): ?>
                                    <li class="page-item">
                                        <a class="page-link" href="?page=<?php echo $page + 1; ?><?php echo $queryString; ?>" aria-label="بعدی">
                                            <span aria-hidden="true">&raquo;</span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </nav>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        // چارت کلیک روی دکمه‌ها
        const buttonClickData = <?php echo json_encode($buttonClickStats); ?>;
        new Chart(document.getElementById('buttonClickChart'), {
            type: 'bar',
            data: {
                labels: buttonClickData.map(item => item['action_name']),
                datasets: [{
                    label: 'تعداد کلیک',
                    data: buttonClickData.map(item => item['click_count']),
                    backgroundColor: 'rgba(102, 126, 234, 0.6)',
                    borderColor: 'rgba(102, 126, 234, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
        
        // چارت بخش‌ها
        const sectionData = <?php echo json_encode($sectionStats); ?>;
        new Chart(document.getElementById('sectionChart'), {
            type: 'pie',
            data: {
                labels: sectionData.map(item => item['section']),
                datasets: [{
                    label: 'تعداد استفاده',
                    data: sectionData.map(item => item['usage_count']),
                    backgroundColor: [
                        'rgba(255, 99, 132, 0.6)',
                        'rgba(54, 162, 235, 0.6)',
                        'rgba(255, 206, 86, 0.6)',
                        'rgba(75, 192, 192, 0.6)',
                        'rgba(153, 102, 255, 0.6)',
                        'rgba(255, 159, 64, 0.6)'
                    ]
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false
            }
        });
        
        // چارت فعالیت روزانه
        const dailyData = <?php echo json_encode($dailyStats); ?>;
        new Chart(document.getElementById('dailyChart'), {
            type: 'line',
            data: {
                labels: dailyData.map(item => item['date']),
                datasets: [{
                    label: 'کل فعالیت‌ها',
                    data: dailyData.map(item => item['total_activities']),
                    borderColor: 'rgba(75, 192, 192, 1)',
                    backgroundColor: 'rgba(75, 192, 192, 0.2)',
                    tension: 0.1
                }, {
                    label: 'کاربران منحصر به فرد',
                    data: dailyData.map(item => item['unique_users']),
                    borderColor: 'rgba(255, 99, 132, 1)',
                    backgroundColor: 'rgba(255, 99, 132, 0.2)',
                    tension: 0.1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false
            }
        });
        
        // چارت فعالیت ساعتی
        const hourlyData = <?php echo json_encode($hourlyStats); ?>;
        new Chart(document.getElementById('hourlyChart'), {
            type: 'bar',
            data: {
                labels: hourlyData.map(item => item['hour'] + ':00'),
                datasets: [{
                    label: 'تعداد فعالیت',
                    data: hourlyData.map(item => item['activity_count']),
                    backgroundColor: 'rgba(153, 102, 255, 0.6)',
                    borderColor: 'rgba(153, 102, 255, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    </script>
</body>
</html>

